#ifndef _SHA_256
#define _SHA_256

/*
first 32 bits of the fractional parts of the cube roots of the first 64 primes 2..311
*/
#define CONST_K00  0x0428a2f98 
#define CONST_K01  0x071374491 
#define CONST_K02  0x0b5c0fbcf 
#define CONST_K03  0x0e9b5dba5 
#define CONST_K04  0x03956c25b 
#define CONST_K05  0x059f111f1 
#define CONST_K06  0x0923f82a4 
#define CONST_K07  0x0ab1c5ed5
#define CONST_K08  0x0d807aa98 
#define CONST_K09  0x012835b01 
#define CONST_K10  0x0243185be 
#define CONST_K11  0x0550c7dc3 
#define CONST_K12  0x072be5d74 
#define CONST_K13  0x080deb1fe 
#define CONST_K14  0x09bdc06a7 
#define CONST_K15  0x0c19bf174
#define CONST_K16  0x0e49b69c1 
#define CONST_K17  0x0efbe4786 
#define CONST_K18  0x00fc19dc6 
#define CONST_K19  0x0240ca1cc 
#define CONST_K20  0x02de92c6f 
#define CONST_K21  0x04a7484aa 
#define CONST_K22  0x05cb0a9dc 
#define CONST_K23  0x076f988da
#define CONST_K24  0x0983e5152 
#define CONST_K25  0x0a831c66d 
#define CONST_K26  0x0b00327c8 
#define CONST_K27  0x0bf597fc7 
#define CONST_K28  0x0c6e00bf3 
#define CONST_K29  0x0d5a79147 
#define CONST_K30  0x006ca6351 
#define CONST_K31  0x014292967
#define CONST_K32  0x027b70a85 
#define CONST_K33  0x02e1b2138 
#define CONST_K34  0x04d2c6dfc 
#define CONST_K35  0x053380d13 
#define CONST_K36  0x0650a7354 
#define CONST_K37  0x0766a0abb 
#define CONST_K38  0x081c2c92e 
#define CONST_K39  0x092722c85
#define CONST_K40  0x0a2bfe8a1 
#define CONST_K41  0x0a81a664b 
#define CONST_K42  0x0c24b8b70 
#define CONST_K43  0x0c76c51a3 
#define CONST_K44  0x0d192e819 
#define CONST_K45  0x0d6990624 
#define CONST_K46  0x0f40e3585 
#define CONST_K47  0x0106aa070
#define CONST_K48  0x019a4c116 
#define CONST_K49  0x01e376c08 
#define CONST_K50  0x02748774c 
#define CONST_K51  0x034b0bcb5 
#define CONST_K52  0x0391c0cb3 
#define CONST_K53  0x04ed8aa4a 
#define CONST_K54  0x05b9cca4f 
#define CONST_K55  0x0682e6ff3
#define CONST_K56  0x0748f82ee 
#define CONST_K57  0x078a5636f 
#define CONST_K58  0x084c87814 
#define CONST_K59  0x08cc70208 
#define CONST_K60  0x090befffa 
#define CONST_K61  0x0a4506ceb 
#define CONST_K62  0x0bef9a3f7 
#define CONST_K63  0x0c67178f2

/*Initial Hash value for the SHA-256.
first 32 bits of the fractional parts of the square roots of the first 8 primes 2..19*/
#define CONST_H00  0x06a09e667
#define CONST_H01  0x0bb67ae85
#define CONST_H02  0x03c6ef372
#define CONST_H03  0x0a54ff53a
#define CONST_H04  0x0510e527f
#define CONST_H05  0x09b05688c
#define CONST_H06  0x01f83d9ab
#define CONST_H07  0x05be0cd19

#pragma pack (push,1)
typedef struct _SHA256_VAR{
	UINT32 VarH00;
	UINT32 VarH01;
	UINT32 VarH02;
	UINT32 VarH03;
	UINT32 VarH04;
	UINT32 VarH05;
	UINT32 VarH06;
	UINT32 VarH07;

	UINT32 VarA;
	UINT32 VarB;
	UINT32 VarC;
	UINT32 VarD;
	UINT32 VarE;
	UINT32 VarF;
	UINT32 VarG;
	UINT32 VarH;
}SHA256_VAR;
#pragma pack (pop)

void Hash256Target(UINT8 *pMsg, UINT32 MsgLen, UINT8 *pHash);
void Hash256Update(UINT8 *pMsg, UINT32 UpdLen, UINT32 *pAccumulatedLen);
void Hash256Final(UINT8 *pMsg, UINT32 MsgLen, UINT32 *pAccumulatedLen, UINT8 *pHashOut);
void Sha256Block(UINT8 *pMsg);

UINT32 SetTEMP1(UINT32 u32Indx);
UINT32 SetTEMP2();

//Assembly helpers
UINT32 F_TETA0(UINT32 u32Src);
UINT32 F_TETA1(UINT32 u32Src);
UINT32 F_SIGMA1(UINT32 u32Src);
UINT32 F_SIGMA0(UINT32 u32Src);
UINT32 F_CH(UINT32 u32Src1, UINT32 u32Src2, UINT32 u32Src3);
UINT32 F_MAJ(UINT32 u32Src1, UINT32 u32Src2, UINT32 u32Src3);
#endif //_SHA_256